/* eslint-disable max-len */
define([
    'underscore',
    'modules/page/popup/popup-view',
    'text!modules/new-appointment-request/views/direct/preferred-date/templates/switch-to-request-popup.html',
], function(_, PopupView, template) {
    'use strict';

    var defaultMessage = 'Scheduling Clerks may be able to find additional dates and times for you. \
                                To request assistance, change the scheduling method you selected to "Request help scheduling" \
                                and submit the request details. A clerk will contact you to provide assistance.\
                            '.trim();

    return PopupView.extend({
        id: 'switch-to-request-popup',
        template: template,
        defaultMessageText: defaultMessage,

        initialize: function(options) {
            this._initializeElAfterClose(options.elAfterClose);
            this.customMessage = options.customMessage;
        },
        templateContext: function() {
            return {
                customMessageText: _.isEmpty(this.customMessage) ? defaultMessage : this.customMessage,
            };
        },
    });
});
